import numpy as np
import math
import random

class COCO:
    def __init__(self,dictionary):
        self.x_dim = dictionary['x_dim']
        self.constraint_dim =  dictionary['constraint_dim']
        self.A_range = dictionary['A_range']
        self.a_range = dictionary['a_range']

        def formH():
            return np.random.uniform(low=-1, high=1, size=(4, self.x_dim))

        def formA():
            return np.random.uniform(low=self.A_range[0], high=self.A_range[1], size=(self.constraint_dim, self.x_dim))

        def forma():
            return np.random.uniform(low=self.a_range[0], high=self.a_range[1], size=(self.constraint_dim, 1))

        def formloss():
            Hlist = []
            zlist = []
            for _ in range(5000):
                H = formH()
                Hlist.append(H)
                one = [[1] for _ in range(self.x_dim)]
                zlist.append(np.matmul(H, one) + np.random.normal(size=(4, 1)))
            return Hlist, zlist

        def formcon():
            Alist = []
            alist = []
            for _ in range(5000):
                Alist.append(formA())
                alist.append(forma())
            return Alist, alist

        self.loss = formloss()
        self.constraint = formcon()

    def observe(self,round):
        return self.loss[0][round],self.loss[1][round],self.constraint[0][round],self.constraint[1][round]
